# SaaS OS — Public Quick Reference Guide (v1)

This guide provides a high-level overview of **SaaS OS**:  
what it is, how it’s used, and when it’s the right system for your product.

It is intended for:
- Founders
- Designers
- Engineers
- AI-assisted teams (Cursor, Copilot, etc.)

No prior knowledge of the internal system is required.

---

## What SaaS OS Is

SaaS OS is a **contract-driven UI system** designed for:
- Predictable frontend behaviour
- AI-safe code generation
- Scalable product development

It defines **what UI components are allowed to do**,  
**what they must never do**,  
and **who owns each decision** (UI vs application vs backend).

At its core:
> **UI does not own truth. Contracts do.**

---

## What SaaS OS Is Not

SaaS OS is **not**:
- A component library with visual freedom
- A UI kit you “tweak per screen”
- A design trend system
- A backend framework
- A state-management solution

If you want pixel freedom or per-page UI logic, SaaS OS is **not** the right fit.

---

## Key Principles (Non-Negotiable)

### 1. Contracts Over Components
Every UI element is defined by a **contract**, not by implementation.

If behaviour is not documented, it must not exist.

---

### 2. State Over Appearance
Visual styling reflects state — it does not define it.

States are:
- Explicit
- Owned by the parent
- Never inferred by UI

---

### 3. Ownership Is Always Clear
Each responsibility belongs to exactly one owner:

| Responsibility | Owner |
|---------------|------|
| Data | Backend / API |
| State | Application layer |
| Behaviour | Contracts |
| Rendering | UI component |

No overlap. No guessing.

---

## What You Get

### Included
- Enterprise-grade UI contracts
- Token-driven design system
- Predictable component behaviour
- AI-safe generation rules
- Figma as source of truth

### Not Included
- Business logic
- Permissions
- API orchestration
- Storage or persistence
- Product-specific decisions

---

## Typical Usage

SaaS OS is used when you want:
- Consistent UI across multiple products
- Teams working in parallel without UI drift
- AI-generated code that is safe and reviewable
- A clear boundary between product logic and UI

Common use cases:
- SaaS dashboards
- Admin panels
- Internal tools
- Multi-tenant platforms

---

## How It Fits Into Your Workflow

### Design
- Figma is the **authoritative source**
- Tokens, components, and patterns are locked
- No local overrides

### Engineering
- Engineers reference contracts
- Behaviour is implemented exactly as specified
- Code reviews validate against contracts

### AI (Cursor, etc.)
- AI tools consume **extracted contracts**
- AI is not allowed to infer behaviour
- Output must be traceable to a contract

---

## Versioning & Stability

- SaaS OS v1 prioritises **stability over flexibility**
- Behavioural changes require version bumps
- Visual refinements are allowed if intent is unchanged

---

## When Not to Use SaaS OS

Avoid SaaS OS if:
- UI behaviour changes per page
- Product relies on heavy visual experimentation
- Designers need full creative freedom per screen
- You expect components to “figure things out”

---

## Next Steps

- Review the **Figma source** (read-only)
- Browse the **component index**
- Read the **Do / Don’t guide**
- Explore usage examples

For implementation details, refer to the **Internal Engineering Guide**.

---

## Final Note

SaaS OS is opinionated by design.

It trades flexibility for:
- Predictability
- Scale
- AI safety
- Long-term maintainability

If those matter to you — this system is built for you.